from subprocess import check_output


def generate_requirements():
    return check_output(['pip', 'freeze']).decode('utf-8').split('\n')


def write_to_file(requirements):
    with open('../requirements.txt', 'w') as file:
        for requirement in requirements:
            file.write(requirement + '\n')


if __name__ == '__main__':
    requirements = generate_requirements()
    write_to_file(requirements)